<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo APP_NAME; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: Arial, sans-serif; background:#f4f4f4; margin:0; }
        .topbar { background:#2c3e50; color:#fff; padding:10px 20px; display:flex; justify-content:space-between; align-items:center; }
        .container { max-width:1200px; margin:20px auto; background:#fff; padding:20px; box-shadow:0 0 5px rgba(0,0,0,0.1); }
        a { color:#2c3e50; text-decoration:none; }
        nav a { margin-right:15px; }
        table { width:100%; border-collapse:collapse; margin-top:10px; }
        th, td { border:1px solid #ddd; padding:8px; font-size:14px; }
        th { background:#f0f0f0; text-align:left; }
        .btn { display:inline-block; padding:6px 12px; background:#2c3e50; color:#fff; border-radius:3px; font-size:14px; }
        .btn-secondary { background:#7f8c8d; }
        .btn-danger { background:#c0392b; }
        .alert { padding:10px; margin-bottom:10px; border-radius:3px; }
        .alert-success { background:#d4edda; color:#155724; }
        .alert-error { background:#f8d7da; color:#721c24; }
        .form-group { margin-bottom:10px; }
        label { display:block; font-weight:bold; margin-bottom:4px; }
        input[type="text"], input[type="number"], input[type="date"], input[type="email"], select, textarea {
            width:100%; padding:6px; box-sizing:border-box;
        }
    </style>
</head>
<body>
<div class="topbar">
    <div><strong><?php echo APP_NAME; ?></strong></div>
    <div>
        <?php if (!empty($_SESSION['user'])): ?>
            Logged in as <?php echo htmlspecialchars($_SESSION['user']['name']); ?> |
            <a href="dashboard.php" style="color:#ecf0f1;">Dashboard</a> |
            <a href="clients.php" style="color:#ecf0f1;">Clients</a> |
            <a href="laybys.php" style="color:#ecf0f1;">Lay-Bys</a> |
            <a href="logout.php" style="color:#ecf0f1;">Logout</a>
        <?php endif; ?>
    </div>
</div>
<div class="container">
