<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';

$db = get_db();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $address = trim($_POST['address'] ?? '');

    if ($name) {
        $stmt = $db->prepare('INSERT INTO clients (name, phone, email, address) VALUES (?,?,?,?)');
        $stmt->execute([$name, $phone, $email, $address]);
        $message = 'Client added successfully.';
    } else {
        $message = 'Name is required.';
    }
}

$clients = $db->query('SELECT * FROM clients ORDER BY created_at DESC')->fetchAll();
?>

<h2>Clients</h2>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<h3>Add New Client</h3>
<form method="post">
    <div class="form-group">
        <label>Client Name</label>
        <input type="text" name="name" required>
    </div>
    <div class="form-group">
        <label>Phone</label>
        <input type="text" name="phone">
    </div>
    <div class="form-group">
        <label>Email</label>
        <input type="email" name="email">
    </div>
    <div class="form-group">
        <label>Address</label>
        <textarea name="address" rows="2"></textarea>
    </div>
    <button class="btn" type="submit">Save Client</button>
</form>

<h3 style="margin-top:25px;">Client List</h3>
<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Address</th>
            <th>Created</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($clients as $c): ?>
            <tr>
                <td><?php echo $c['id']; ?></td>
                <td><?php echo htmlspecialchars($c['name']); ?></td>
                <td><?php echo htmlspecialchars($c['phone']); ?></td>
                <td><?php echo htmlspecialchars($c['email']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($c['address'])); ?></td>
                <td><?php echo $c['created_at']; ?></td>
            </tr>
        <?php endforeach; ?>
        <?php if (!$clients): ?>
            <tr><td colspan="6">No clients yet.</td></tr>
        <?php endif; ?>
    </tbody>
</table>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
