<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';

$db = get_db();
$layby_id = (int)($_GET['id'] ?? 0);
if (!$layby_id) {
    echo "Invalid lay-by.";
    require_once __DIR__ . '/../includes/footer.php';
    exit;
}

// Fetch layby details with totals
$stmt = $db->prepare("
    SELECT l.*, c.name AS client_name,
           IFNULL(SUM(p.amount),0) AS total_paid,
           (l.total_amount - IFNULL(SUM(p.amount),0)) AS outstanding
    FROM laybys l
    JOIN clients c ON l.client_id = c.id
    LEFT JOIN layby_payments p ON p.layby_id = l.id
    WHERE l.id = ?
    GROUP BY l.id
");
$stmt->execute([$layby_id]);
$layby = $stmt->fetch();

if (!$layby) {
    echo "Lay-by not found.";
    require_once __DIR__ . '/../includes/footer.php';
    exit;
}

$message = '';

// Handle new payment
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = (float)($_POST['amount'] ?? 0);
    $payment_date = $_POST['payment_date'] ?: date('Y-m-d');
    $method = $_POST['method'] ?? 'cash';
    $reference = trim($_POST['reference'] ?? '');

    if ($amount > 0) {
        $stmt = $db->prepare('INSERT INTO layby_payments (layby_id, payment_date, amount, method, reference) VALUES (?,?,?,?,?)');
        $stmt->execute([$layby_id, $payment_date, $amount, $method, $reference]);
        $message = 'Payment recorded successfully.';

        // Refresh layby totals
        header('Location: layby_payments.php?id=' . $layby_id);
        exit;
    } else {
        $message = 'Enter a valid amount.';
    }
}

// Get payment history
$stmt = $db->prepare('SELECT * FROM layby_payments WHERE layby_id = ? ORDER BY payment_date ASC, id ASC');
$stmt->execute([$layby_id]);
$payments = $stmt->fetchAll();
?>

<h2>Lay-By Payments</h2>

<p>
    <strong>Lay-By #:</strong> <?php echo htmlspecialchars($layby['layby_number']); ?><br>
    <strong>Client:</strong> <?php echo htmlspecialchars($layby['client_name']); ?><br>
    <strong>Total Amount:</strong> <?php echo number_format($layby['total_amount'], 2); ?><br>
    <strong>Total Paid:</strong> <?php echo number_format($layby['total_paid'], 2); ?><br>
    <strong>Outstanding (Short):</strong> <?php echo number_format($layby['outstanding'], 2); ?><br>
</p>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<h3>Add Payment</h3>
<form method="post">
    <div class="form-group">
        <label>Payment Date</label>
        <input type="date" name="payment_date" value="<?php echo date('Y-m-d'); ?>">
    </div>
    <div class="form-group">
        <label>Amount</label>
        <input type="number" step="0.01" name="amount" required>
    </div>
    <div class="form-group">
        <label>Method</label>
        <select name="method">
            <option value="cash">Cash</option>
            <option value="card">Card</option>
            <option value="eft">EFT</option>
            <option value="other">Other</option>
        </select>
    </div>
    <div class="form-group">
        <label>Reference</label>
        <input type="text" name="reference" placeholder="Slip number, etc.">
    </div>
    <button class="btn" type="submit">Save Payment</button>
</form>

<h3 style="margin-top:25px;">Payment History</h3>
<table>
    <thead>
        <tr>
            <th>Date</th>
            <th>Amount</th>
            <th>Method</th>
            <th>Reference</th>
            <th>Captured At</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($payments as $p): ?>
            <tr>
                <td><?php echo htmlspecialchars($p['payment_date']); ?></td>
                <td><?php echo number_format($p['amount'], 2); ?></td>
                <td><?php echo htmlspecialchars($p['method']); ?></td>
                <td><?php echo htmlspecialchars($p['reference']); ?></td>
                <td><?php echo htmlspecialchars($p['created_at']); ?></td>
            </tr>
        <?php endforeach; ?>
        <?php if (!$payments): ?>
            <tr><td colspan="5">No payments yet.</td></tr>
        <?php endif; ?>
    </tbody>
</table>

<p style="margin-top:15px;">
    <a class="btn btn-secondary" href="laybys.php">&laquo; Back to Lay-Bys</a>
</p>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
