<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/header.php';

$db = get_db();
$message = '';

// Fetch clients for dropdown
$clients = $db->query('SELECT id, name FROM clients ORDER BY name ASC')->fetchAll();

// Handle create layby
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'create') {
    $client_id = (int)($_POST['client_id'] ?? 0);
    $branch_id = (int)($_SESSION['user']['branch_id'] ?? 1);
    $start_date = $_POST['start_date'] ?: date('Y-m-d');
    $total_amount = (float)($_POST['total_amount'] ?? 0);
    $deposit_amount = (float)($_POST['deposit_amount'] ?? 0);
    $notes = trim($_POST['notes'] ?? '');

    if ($client_id && $total_amount > 0) {
        // Generate simple layby number
        $layby_number = 'LB' . date('YmdHis');

        $stmt = $db->prepare('INSERT INTO laybys (layby_number, branch_id, client_id, start_date, total_amount, deposit_amount, notes, created_by)
                              VALUES (?,?,?,?,?,?,?,?)');
        $stmt->execute([$layby_number, $branch_id, $client_id, $start_date, $total_amount, $deposit_amount, $notes, $_SESSION['user']['id']]);

        $layby_id = $db->lastInsertId();

        // If deposit > 0, record as first payment
        if ($deposit_amount > 0) {
            $stmt = $db->prepare('INSERT INTO layby_payments (layby_id, payment_date, amount, method, reference)
                                  VALUES (?,?,?,?,?)');
            $stmt->execute([$layby_id, $start_date, $deposit_amount, 'cash', 'Deposit']);
        }

        $message = 'Lay-by created successfully with number ' . htmlspecialchars($layby_number) . '.';
    } else {
        $message = 'Please select a client and enter a total amount.';
    }
}

// Fetch laybys with balances
$laybys = $db->query("
    SELECT l.*, c.name AS client_name,
           IFNULL(SUM(p.amount),0) AS total_paid,
           (l.total_amount - IFNULL(SUM(p.amount),0)) AS outstanding
    FROM laybys l
    JOIN clients c ON l.client_id = c.id
    LEFT JOIN layby_payments p ON p.layby_id = l.id
    GROUP BY l.id
    ORDER BY l.created_at DESC
")->fetchAll();
?>

<h2>Lay-Bys</h2>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo $message; ?></div>
<?php endif; ?>

<h3>Create New Lay-By</h3>
<form method="post">
    <input type="hidden" name="action" value="create">
    <div class="form-group">
        <label>Client</label>
        <select name="client_id" required>
            <option value="">-- Select Client --</option>
            <?php foreach ($clients as $cl): ?>
                <option value="<?php echo $cl['id']; ?>"><?php echo htmlspecialchars($cl['name']); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="form-group">
        <label>Start Date</label>
        <input type="date" name="start_date" value="<?php echo date('Y-m-d'); ?>">
    </div>
    <div class="form-group">
        <label>Total Amount</label>
        <input type="number" step="0.01" name="total_amount" required>
    </div>
    <div class="form-group">
        <label>Deposit Amount (optional)</label>
        <input type="number" step="0.01" name="deposit_amount">
    </div>
    <div class="form-group">
        <label>Notes</label>
        <textarea name="notes" rows="2"></textarea>
    </div>
    <button class="btn" type="submit">Create Lay-By</button>
</form>

<h3 style="margin-top:25px;">Existing Lay-Bys</h3>
<table>
    <thead>
        <tr>
            <th>Lay-By #</th>
            <th>Client</th>
            <th>Start Date</th>
            <th>Total</th>
            <th>Paid</th>
            <th>Outstanding</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($laybys as $lb): ?>
            <tr>
                <td><?php echo htmlspecialchars($lb['layby_number']); ?></td>
                <td><?php echo htmlspecialchars($lb['client_name']); ?></td>
                <td><?php echo htmlspecialchars($lb['start_date']); ?></td>
                <td><?php echo number_format($lb['total_amount'], 2); ?></td>
                <td><?php echo number_format($lb['total_paid'], 2); ?></td>
                <td><?php echo number_format($lb['outstanding'], 2); ?></td>
                <td><?php echo htmlspecialchars($lb['status']); ?></td>
                <td><a class="btn btn-secondary" href="layby_payments.php?id=<?php echo $lb['id']; ?>">Payments</a></td>
            </tr>
        <?php endforeach; ?>
        <?php if (!$laybys): ?>
            <tr><td colspan="8">No lay-bys yet.</td></tr>
        <?php endif; ?>
    </tbody>
</table>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
